#include "MTIDXAViewer.h"

MTSimpleResourceTemplate MTIDXAViewer::kIDXAFormatTemplate =
{
	{
		ONI_RESOURCE_HEADER
		
		{	kTypeUInt16 | kTypeIsFiller |
			kTypeDataBlock | DATA_AREA_1(10),		"Filler" },
		
		{	kTypeDecUInt32 | kTypeStoreToVariable |
			DATA_AREA_1(0) /*| kTypeIsFiller*/,		"Number of Entries" },
		{	kTypeStartSection | DATA_AREA_1(0),		"Entries" },
		
		{	kTypeUInt32,							"Index" },
		
		{	kTypeEndSection },
		
		{	0 }
	}
};

void MTIDXAViewer::PostProcess(void)
{
	UInt32	numEntries = GetNumResourceEntries() - 3;
	
	entries.resize(numEntries);
	
	for(UInt32 i = 0; i < numEntries; i++)
	{
		MTParsedResourceEntry	* entry;
		
		entry = GetResourceEntry(3 + i);
		
		entries[i] = entry->data;
	}
}